-- Build 42.x — Detailed Skill Tooltip: Animal Care (Husbandry)
-- Drop this into: client/SkillDefs/AnimalCare.lua
-- Requires: API/DST_API (your DST mod core)

require "API/DST_API"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "AnimalCare"

ST.addContributor(KEY, function(ctx)
    local lvl = ctx.getLevel()

    ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))
    if lvl < 3 then
        ctx.add(ST.getText("IGUI_DST_AnimalCare_val_LessInfo"))
    elseif lvl < 6 then
        ctx.add(ST.getText("IGUI_DST_AnimalCare_val_MoreInfo"))
    else
        ctx.add(ST.getText("IGUI_DST_AnimalCare_val_ExactInfo"))
    end

    if lvl >= 5 then
        ctx.add(ST.getText("IGUI_DST_AnimalCare_val_Weight"))
    end

    ------------------------------------------------------------
    -- Egg Layer Info
    ------------------------------------------------------------
    if lvl >= 3 then
        ctx.addHeader(ST.getText("IGUI_DST_AnimalCare_hdr_EggLayers"))
        ctx.add(ST.getText("IGUI_DST_AnimalCare_val_Fertile"))
    end
    if lvl >= 4 then
        ctx.add(ST.getText("IGUI_DST_AnimalCare_val_Clutch"))
    end
    if lvl >= 5 then
        ctx.add(ST.getText("IGUI_DST_AnimalCare_val_Laying"))
    end

    ------------------------------------------------------------
    -- Mammal Info
    ------------------------------------------------------------
    if lvl >= 4 then
        ctx.addHeader(ST.getText("IGUI_DST_AnimalCare_hdr_Mammals"))
        ctx.add(ST.getText("IGUI_DST_AnimalCare_val_Breeding"))
    end
    if lvl >= 5 then
        ctx.add(ST.getText("IGUI_DST_AnimalCare_val_Pregnancy"))
        ctx.add(ST.getText("IGUI_DST_AnimalCare_val_Mating"))
        ctx.add(ST.getText("IGUI_DST_AnimalCare_val_Udder"))
    end
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)
